# 📖 راهنمای نصب کامل - فروشگاه دیجیتال

## 🎯 مراحل نصب روی cPanel

### پیش‌نیازهای هاست
- ✅ 5GB فضای ذخیره‌سازی
- ✅ پهنای باند نامحدود
- ✅ وب سرور LiteSpeed یا Apache
- ✅ PHP 7.4 یا بالاتر
- ✅ دسترسی cPanel
- ✅ دسترسی FTP (اختیاری)

---

## 📦 مرحله 1: آماده‌سازی فایل‌ها

### روش اول: استفاده از فایل‌های آماده

1. فایل `digital-shop.zip` را از پوشه پروژه دانلود کنید
2. این فایل شامل همه فایل‌های لازم است

### روش دوم: Build دستی

اگر می‌خواهید خودتان build کنید:

```bash
# نصب Node.js 18+
# دانلود پروژه
cd digital-shop

# نصب وابستگی‌ها
npm install

# Build پروژه
npm run build

# خروجی در پوشه dist قرار می‌گیرد
```

---

## 🚀 مرحله 2: آپلود روی هاست

### روش اول: File Manager cPanel

1. وارد cPanel شوید
2. روی **File Manager** کلیک کنید
3. به پوشه `public_html` بروید
4. روی **Upload** کلیک کنید
5. فایل `digital-shop.zip` را انتخاب و آپلود کنید
6. پس از آپلود، روی فایل راست‌کلیک کنید و **Extract** را بزنید
7. محتوای پوشه `dist` را به ریشه `public_html` منتقل کنید

### روش دوم: FTP

1. یک FTP Client مانند FileZilla نصب کنید
2. به هاست خود متصل شوید:
   - Host: `yourdomain.com` یا IP سرور
   - Username: نام کاربری cPanel
   - Password: رمز عبور cPanel
   - Port: 21
3. به پوشه `public_html` بروید
4. محتوای پوشه `dist` را آپلود کنید

---

## ⚙️ مرحله 3: تنظیمات .htaccess

فایل `.htaccess` باید در ریشه `public_html` قرار داشته باشد. اگر وجود ندارد:

1. در File Manager، روی **+ File** کلیک کنید
2. نام فایل را `.htaccess` بگذارید
3. کد زیر را در آن قرار دهید:

```apache
<IfModule mod_rewrite.c>
  RewriteEngine On
  RewriteBase /
  RewriteRule ^index\.html$ - [L]
  RewriteCond %{REQUEST_FILENAME} !-f
  RewriteCond %{REQUEST_FILENAME} !-d
  RewriteRule . /index.html [L]
</IfModule>

# Enable gzip compression
<IfModule mod_deflate.c>
  AddOutputFilterByType DEFLATE text/html text/css application/javascript
</IfModule>

# Cache static files
<IfModule mod_expires.c>
  ExpiresActive On
  ExpiresByType image/jpeg "access plus 1 year"
  ExpiresByType image/png "access plus 1 year"
  ExpiresByType text/css "access plus 1 month"
  ExpiresByType application/javascript "access plus 1 month"
</IfModule>
```

---

## 🔧 مرحله 4: تنظیمات PHP

1. در cPanel، روی **Select PHP Version** کلیک کنید
2. نسخه **PHP 7.4** یا **PHP 8.0** را انتخاب کنید
3. روی **Set as current** کلیک کنید
4. مطمئن شوید افزونه‌های زیر فعال هستند:
   - ✅ mbstring
   - ✅ json
   - ✅ fileinfo

---

## 🌐 مرحله 5: تست سایت

1. مرورگر را باز کنید
2. آدرس سایت خود را وارد کنید: `https://yourdomain.com`
3. فروشگاه باید نمایش داده شود

### تست پنل مدیریت

1. به آدرس `https://yourdomain.com/admin` بروید
2. با اطلاعات زیر وارد شوید:
   - **ایمیل**: `admin@digitalshop.ir`
   - **رمز عبور**: `admin123`

⚠️ **مهم**: پس از اولین ورود، حتماً رمز عبور را تغییر دهید!

---

## 🔒 مرحله 6: تغییر رمز عبور مدیر

1. وارد پنل مدیریت شوید
2. به بخش **کاربران** بروید
3. کاربر admin را پیدا کنید
4. رمز عبور جدید تنظیم کنید

---

## ⚡ مرحله 7: بهینه‌سازی

### فعال‌سازی SSL (HTTPS)

1. در cPanel، روی **SSL/TLS** کلیک کنید
2. گواهی SSL رایگان Let's Encrypt را نصب کنید
3. سایت باید با HTTPS باز شود

### فعال‌سازی فشرده‌سازی

1. در cPanel، روی **Optimize Website** کلیک کنید
2. گزینه **Compress all content** را انتخاب کنید
3. روی **Update Settings** کلیک کنید

---

## 📋 چک‌لیست نصب

- [ ] فایل‌ها آپلود شده‌اند
- [ ] فایل `.htaccess` تنظیم شده است
- [ ] PHP 7.4+ فعال است
- [ ] SSL نصب شده است
- [ ] فروشگاه باز می‌شود
- [ ] پنل مدیریت کار می‌کند
- [ ] رمز عبور مدیر تغییر کرده است
- [ ] تنظیمات سایت انجام شده است

---

## 🆘 عیب‌یابی

### مشکل 1: صفحه سفید نمایش داده می‌شود

**راه‌حل:**
1. کش مرورگر را پاک کنید (Ctrl+Shift+R)
2. LocalStorage را پاک کنید
3. فایل‌ها را دوباره آپلود کنید

### مشکل 2: خطای 404

**راه‌حل:**
1. بررسی کنید فایل `.htaccess` وجود دارد
2. محتوای `.htaccess` را بررسی کنید
3. مطمئن شوید `mod_rewrite` فعال است

### مشکل 3: استایل‌ها لود نمی‌شوند

**راه‌حل:**
1. مسیر فایل‌ها را بررسی کنید
2. فایل‌های CSS باید در پوشه `assets` باشند
3. کش CDN را پاک کنید (اگر CDN دارید)

### مشکل 4: نمی‌توانم وارد پنل مدیریت شوم

**راه‌حل:**
1. مطمئن شوید از ایمیل و رمز صحیح استفاده می‌کنید
2. LocalStorage را پاک کنید
3. صفحه را رفرش کنید

---

## 📞 پشتیبانی

در صورت بروز مشکل:

1. ابتدا این راهنما را کامل بخوانید
2. کش مرورگر و LocalStorage را پاک کنید
3. فایل‌ها را دوباره آپلود کنید

---

## 🎉 تبریک!

فروشگاه شما با موفقیت نصب شد! 🎊

**آدرس فروشگاه**: `https://yourdomain.com`
**پنل مدیریت**: `https://yourdomain.com/admin`

---

**موفق باشید!** 🚀
