# 🛒 فروشگاه دیجیتال - Digital Shop

یک فروشگاه آنلاین کامل و حرفه‌ای برای فروش کالاهای دیجیتال با پنل مدیریت جامع.

## ✨ ویژگی‌ها

### 🌐 فروشگاه
- ✅ طراحی مدرن و ریسپانسیو
- ✅ پشتیبانی کامل از زبان فارسی و انگلیسی (RTL/LTR)
- ✅ حالت شب و روز (Dark/Light Mode)
- ✅ سیستم چندزبانه با قابلیت تغییر آسان زبان
- ✅ صفحه اصلی با اسلایدر و محصولات ویژه
- ✅ دسته‌بندی محصولات
- ✅ جستجو و فیلتر پیشرفته محصولات
- ✅ صفحه جزئیات محصول با گالری تصاویر
- ✅ سبد خرید کامل
- ✅ فرآیند پرداخت
- ✅ سیستم وبلاگ
- ✅ صفحات تماس با ما و درباره ما

### 🔐 پنل مدیریت
- ✅ داشبورد با آمار و نمودار
- ✅ مدیریت کامل محصولات (افزودن، ویرایش، حذف)
- ✅ مدیریت دسته‌بندی‌ها
- ✅ مدیریت سفارشات با تغییر وضعیت
- ✅ مدیریت وبلاگ
- ✅ مدیریت بنرهای صفحه اصلی
- ✅ مدیریت کاربران
- ✅ تنظیمات سایت
- ✅ پشتیبان‌گیری و بازیابی داده‌ها

### 🔒 امنیت
- ✅ سیستم احراز هویت کاربران
- ✅ سطوح دسترسی (مدیر/کاربر)
- ✅ ذخیره‌سازی امن داده‌ها در LocalStorage
- ✅ اعتبارسنجی فرم‌ها

## 🚀 نصب و راه‌اندازی روی cPanel

### پیش‌نیازها
- هاست با cPanel
- PHP 7.4 یا بالاتر
- وب سرور Apache یا LiteSpeed
- 5GB فضای ذخیره‌سازی
- دسترسی FTP یا File Manager

### مراحل نصب

#### 1️⃣ آماده‌سازی فایل‌ها

ابتدا پروژه را build کنید:

```bash
cd /mnt/okcomputer/output/app
npm install
npm run build
```

#### 2️⃣ آپلود روی هاست

1. وارد cPanel شوید
2. به File Manager بروید
3. به پوشه `public_html` بروید
4. محتوای پوشه `dist` را آپلود کنید:
   - می‌توانید از File Manager استفاده کنید
   - یا از FTP مانند FileZilla استفاده کنید

#### 3️⃣ تنظیمات .htaccess

فایل `.htaccess` را در ریشه `public_html` ایجاد کنید:

```apache
<IfModule mod_rewrite.c>
  RewriteEngine On
  RewriteBase /
  RewriteRule ^index\.html$ - [L]
  RewriteCond %{REQUEST_FILENAME} !-f
  RewriteCond %{REQUEST_FILENAME} !-d
  RewriteRule . /index.html [L]
</IfModule>

# Enable gzip compression
<IfModule mod_deflate.c>
  AddOutputFilterByType DEFLATE text/html text/css application/javascript
</IfModule>

# Cache static files
<IfModule mod_expires.c>
  ExpiresActive On
  ExpiresByType image/jpeg "access plus 1 year"
  ExpiresByType image/png "access plus 1 year"
  ExpiresByType text/css "access plus 1 month"
  ExpiresByType application/javascript "access plus 1 month"
</IfModule>
```

#### 4️⃣ تنظیمات PHP (در cPanel)

1. وارد cPanel شوید
2. به بخش "Select PHP Version" بروید
3. PHP 7.4 یا 8.0 را انتخاب کنید
4. افزونه‌های زیر را فعال کنید:
   - mbstring
   - json
   - fileinfo

### 🎯 دسترسی به پنل مدیریت

پس از نصب:

- **آدرس فروشگاه**: `https://yourdomain.com`
- **پنل مدیریت**: `https://yourdomain.com/admin`

**اطلاعات ورود پیش‌فرض:**
- ایمیل: `admin@digitalshop.ir`
- رمز عبور: `admin123`

⚠️ **مهم**: پس از اولین ورود، رمز عبور را تغییر دهید!

## 📁 ساختار پروژه

```
digital-shop/
├── src/
│   ├── admin/           # پنل مدیریت
│   │   ├── AdminLayout.tsx
│   │   ├── AdminDashboard.tsx
│   │   ├── AdminProducts.tsx
│   │   ├── AdminCategories.tsx
│   │   ├── AdminOrders.tsx
│   │   ├── AdminBlog.tsx
│   │   ├── AdminBanners.tsx
│   │   ├── AdminUsers.tsx
│   │   ├── AdminSettings.tsx
│   │   └── ProductForm.tsx
│   ├── components/      # کامپوننت‌های مشترک
│   │   ├── Header.tsx
│   │   ├── Footer.tsx
│   │   ├── HeroSlider.tsx
│   │   └── ProductCard.tsx
│   ├── contexts/        # Context ها
│   │   ├── LanguageContext.tsx
│   │   ├── ThemeContext.tsx
│   │   ├── CartContext.tsx
│   │   ├── AuthContext.tsx
│   │   └── DataContext.tsx
│   ├── data/            # داده‌های نمونه
│   │   └── sampleData.ts
│   ├── pages/           # صفحات فروشگاه
│   │   ├── Home.tsx
│   │   ├── Products.tsx
│   │   ├── ProductDetail.tsx
│   │   ├── Cart.tsx
│   │   ├── Checkout.tsx
│   │   ├── OrderSuccess.tsx
│   │   ├── Login.tsx
│   │   ├── Register.tsx
│   │   ├── Blog.tsx
│   │   ├── BlogPost.tsx
│   │   ├── Contact.tsx
│   │   └── About.tsx
│   ├── types/           # تایپ‌های TypeScript
│   │   └── index.ts
│   ├── App.tsx
│   ├── index.css
│   └── main.tsx
├── dist/                # خروجی build
├── index.html
├── package.json
├── tsconfig.json
├── vite.config.ts
└── tailwind.config.js
```

## ⚙️ تنظیمات پیشرفته

### تغییر نام سایت

1. وارد پنل مدیریت شوید
2. به بخش "تنظیمات" بروید
3. نام سایت را تغییر دهید
4. ذخیره کنید

### افزودن محصول جدید

1. وارد پنل مدیریت شوید
2. به بخش "محصولات" بروید
3. روی "افزودن محصول" کلیک کنید
4. اطلاعات محصول را وارد کنید:
   - نام (فارسی و انگلیسی)
   - قیمت
   - موجودی
   - تصاویر
   - مشخصات فنی
   - توضیحات
5. ذخیره کنید

### مدیریت سفارشات

1. وارد پنل مدیریت شوید
2. به بخش "سفارشات" بروید
3. وضعیت سفارش را می‌توانید تغییر دهید:
   - در انتظار
   - در حال پردازش
   - ارسال شده
   - تحویل داده شده
   - لغو شده

### پشتیبان‌گیری

1. وارد پنل مدیریت شوید
2. به بخش "تنظیمات" بروید
3. روی "پشتیبان‌گیری" کلیک کنید
4. فایل JSON دانلود می‌شود

### بازیابی داده‌ها

1. وارد پنل مدیریت شوید
2. به بخش "تنظیمات" بروید
3. روی "بازیابی" کلیک کنید
4. فایل پشتیبان را انتخاب کنید
5. تأیید کنید

## 🔧 توسعه محلی

### پیش‌نیازها
- Node.js 18+
- npm یا yarn

### نصب

```bash
# Clone repository
git clone <repository-url>
cd digital-shop

# Install dependencies
npm install

# Run development server
npm run dev
```

### Build

```bash
npm run build
```

خروجی در پوشه `dist` قرار می‌گیرد.

## 📝 نکات مهم

### SEO
- عنوان صفحات به صورت خودکار تنظیم می‌شود
- متا تگ‌ها قابل تنظیم در بخش تنظیمات هستند
- URL ها بهینه شده‌اند

### عملکرد
- تصاویر بهینه شده‌اند
- کدها فشرده شده‌اند
- کش مرورگر فعال است

### امنیت
- داده‌ها در LocalStorage ذخیره می‌شوند
- توصیه می‌شود در نسخه production از backend واقعی استفاده کنید

## 🆘 پشتیبانی

در صورت بروز مشکل:

1. ابتدا کش مرورگر را پاک کنید
2. LocalStorage را پاک کنید
3. صفحه را رفرش کنید

## 📄 مجوز

این پروژه متن‌باز است و می‌توانید آن را تغییر دهید.

---

**ساخته شده با ❤️ برای فروشگاه‌های آنلاین**
