import { Link } from 'react-router-dom';
import { CheckCircle, Package, Home, FileText } from 'lucide-react';
import { Button } from '@/components/ui/button';
import { Card, CardContent } from '@/components/ui/card';
import { useLanguage } from '@/contexts/LanguageContext';

export function OrderSuccess() {
  const { t } = useLanguage();

  return (
    <div className="min-h-screen flex items-center justify-center py-12 px-4">
      <div className="w-full max-w-lg">
        <Card className="text-center">
          <CardContent className="p-8">
            <div className="w-24 h-24 bg-green-100 dark:bg-green-900/30 rounded-full flex items-center justify-center mx-auto mb-6">
              <CheckCircle className="h-12 w-12 text-green-600" />
            </div>

            <h1 className="text-2xl md:text-3xl font-bold mb-4">
              {t('سفارش شما با موفقیت ثبت شد!', 'Your order has been placed successfully!')}
            </h1>

            <p className="text-muted-foreground mb-8">
              {t(
                'با تشکر از خرید شما. سفارش شما در حال پردازش است و به زودی با شما تماس گرفته خواهد شد.',
                'Thank you for your purchase. Your order is being processed and you will be contacted soon.'
              )}
            </p>

            <div className="space-y-3">
              <Link to="/">
                <Button className="w-full" size="lg">
                  <Home className="h-5 w-5 ml-2" />
                  {t('بازگشت به صفحه اصلی', 'Back to Home')}
                </Button>
              </Link>

              <div className="flex gap-3">
                <Link to="/products" className="flex-1">
                  <Button variant="outline" className="w-full">
                    <Package className="h-5 w-5 ml-2" />
                    {t('ادامه خرید', 'Continue Shopping')}
                  </Button>
                </Link>
                <Link to="/profile" className="flex-1">
                  <Button variant="outline" className="w-full">
                    <FileText className="h-5 w-5 ml-2" />
                    {t('سفارشات من', 'My Orders')}
                  </Button>
                </Link>
              </div>
            </div>

            <div className="mt-8 p-4 bg-muted rounded-lg">
              <p className="text-sm text-muted-foreground">
                {t('سوالی دارید؟ با ما تماس بگیرید', 'Have questions? Contact us')}
              </p>
              <p className="font-medium mt-1">021-12345678</p>
            </div>
          </CardContent>
        </Card>
      </div>
    </div>
  );
}
